package gov.va.med.mhv.util.distributor.http;

/**
 * Enum to identify the version of HTTP that is being utilized.  There are some very distinct parameters
 * that each use that are specific to that particular version
 *
 */
public enum HTTPVersion {
    HTTP_1_1("HTTP 1.1", "1.1"),
    HTTP_1_0("HTTP 1.0", "1.0");
    
    private String msg;
    private String versionNumber;
    
    HTTPVersion(String desc, String versionNumber){
        this.msg = desc;
        this.versionNumber = versionNumber;
    }
    
    public String versionNumber(){
        return versionNumber;
    }
    
    @Override
    public String toString(){
        return msg;
    }
    
    public static HTTPVersion getDefault(){
        return HTTP_1_1;
    }
}